<?php
require "config.php";
header("Content-Type: application/json");

$stmt = $pdo->query("
    SELECT 
        SUM(team = 'bleu') AS bleu,
        SUM(team = 'rouge') AS rouge,
        COUNT(*) as total
    FROM team_queue
");

$data = $stmt->fetch(PDO::FETCH_ASSOC);

// Vérifier si une partie est en cours (2 joueurs présents)
$data['ready'] = ($data['total'] == 2);

// Vérifier si une partie est active dans la table game
$gameStmt = $pdo->prepare("SELECT winner FROM game WHERE id = 1");
$gameStmt->execute();
$gameData = $gameStmt->fetch(PDO::FETCH_ASSOC);

// Si une partie est en cours (winner = 0) et 2 joueurs sont présents, on considère la file comme verrouillée
$data['locked'] = ($data['ready'] && $gameData && $gameData['winner'] == 0);

echo json_encode($data);
?>