const session_id = sessionStorage.getItem("session_id");

async function checkGame() {
  const response = await fetch("game.php", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: `action=status&session_id=${session_id}`
  });
  const data = await response.json();

  document.getElementById("status").textContent = data.message;

  if (data.playing) {
    document.getElementById("hp").textContent =
      `Toi: ${data.hp_me} HP | Adversaire: ${data.hp_enemy} HP`;

    const buttons = document.querySelectorAll("#actions button");
    buttons.forEach(btn => btn.disabled = !data.your_turn);
  }

  if (data.finished) {
    alert(data.winner ? "Tu as gagné !" : "Tu as perdu !");
  }
}

async function attack(choice) {
  await fetch("game.php", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: `action=attack&session_id=${session_id}&move=${choice}`
  });
}

setInterval(checkGame, 2000);
